$(document).ready(function() {

    // consultamos si hay usuario en el localstorage
    var user = local.getNickname();
    if (!user) {
        $('.loading').show();
        window.location.replace("login.html");
    } else {
        $('#user').html(user);
    }

    if ($('#index').length > 0) {
        var urlImageMap = local.getUrlImageMap();
        var isValid = local.validarModulos();
        if (isValid) {
            // desbloqueamos el modulo de preguntas
            $('.boton_modulo5').removeClass('disabled')
        }
        // cambiamos la img del mapa
        $('.mapa_modulos').css("background-image", "url(" + urlImageMap + ")");

        $('.boton_modulo5').click((e) => {
            e.preventDefault();
            if (!isValid) {
                $('#searchModal').modal();
            }
        })
    }

    if ($('#modulo1').length > 0) {
        local.setModuloCompleto(1);
    }
    if ($('#modulo2').length > 0) {
        local.setModuloCompleto(2);
    }
    if ($('#modulo3').length > 0) {
        local.setModuloCompleto(3);
    }
    if ($('#modulo4').length > 0) {
        local.setModuloCompleto(4);
        $('#btnPreguntas').click((e) => {
            e.preventDefault();
            var isValid = local.validarModulos();
            if (!isValid) {
                $('#errorModuloModal').modal();
            } else {
                window.location.replace("preguntas.html");
            }
        })
    }
    if ($('#modulo-preguntas').length > 0) {
        var isValid = local.validarModulos();
        if (!isValid) {
            $('#errorModuloModal').modal();
            setTimeout(() => {
                window.location.replace("index.html");
            }, 1000)

        } else {
            $('.loading').show();
            preguntas();
            $('.loading').hide();
        }

        // 
        $('#responder').click((e) => {
            $('.loading').show();
            let respuestas = $("input:radio.respuestas:checked");
            let respuestas2 = $("input:radio.respuestas:checked").val();
            if (respuestas.length != 5) {
                $('#errorModal').modal();
            } else {
                let paso = true;

                $("input:radio.respuestas:checked").each(function() {

                    var pregunta = parseInt($(this).data('pregunta'));
                    var respuesta = parseInt($(this).val());
                    // console.log(correcta, respuesta);
                    // validamos las respuestas
                    var correcta = local.validarRespuesta(pregunta, respuesta);
                    // si hay respuestas incorrectas
                    if (correcta != respuesta) {
                        paso = false;
                        $('#label-' + pregunta + '-' + respuesta).addClass('error');
                        $('#opcion-' + pregunta + '-' + correcta).attr('checked', true);
                        $('#opcion-' + pregunta + '-' + correcta).prop("checked", true);
                    }
                });

                //
                if (paso) {
                    $('#nuevo_intento').hide();
                    $('#nuevo_intento_front').hide();
                    $('#responder').hide();
                    $('div.generar').show();

                } else {
                    $('#nuevo_intento').show();
                    $('#nuevo_intento_front').show();
                    $('#responder').hide();
                    $('#preguntas').modal();
                }
            }
            $('.loading').hide();
        });
        $('#nuevo_intento, #nuevo_intento_front').click((e) => {
            e.preventDefault();
            $('.loading').show();
            preguntas();
            $('#responder').show();
            $('#nuevo_intento').hide();
            $('#nuevo_intento_front').hide();
            $('#preguntas').modal('hide')
            $('.loading').hide();
        });
        $('.certificado_btn').click((e) => {
            // https://parzibyte.me/blog/2020/09/05/html-pdf-javascript/
            // https://ekoopmans.github.io/html2pdf.js
            e.preventDefault();
            $('.loading').show();
            $('#nombre_certificado_pdf').html($("#nombre_certificado").val());
            var today = new Date();
            var dd = today.getDate();

            var mm = today.getMonth() + 1;
            var yyyy = today.getFullYear();
            if (dd < 10) {
                dd = '0' + dd;
            }

            if (mm < 10) {
                mm = '0' + mm;
            }
            $('#fecha_certificado_pdf').html(dd + '/' + mm + '/' + yyyy);


            const $elementoParaConvertir = document.getElementById('content_pdf'); // <-- Aquí puedes elegir cualquier elemento del DOM
            // html2pdf().from($elementoParaConvertir).toPdf().save('my_document.pdf');

            // html2pdf().from($elementoParaConvertir).toCanvas().save('certificado.pdf');

            html2pdf()
                .set({
                    // margin: 1,
                    filename: 'certificado.pdf',
                    image: {
                        type: 'jpeg',
                        quality: 1
                    },
                    // https://html2canvas.hertzen.com/configuration
                    html2canvas: {
                        scale: 4, // A mayor escala, mejores gráficos, pero más peso
                        letterRendering: true,
                        // windowWidth: 578,
                        // windowHeight: 810,
                        // width: 578,
                        // height: 810,
                        // x: 0,
                        // y: 0,
                    },
                    // https://rawgit.com/MrRio/jsPDF/master/docs/jsPDF.html
                    jsPDF: {
                        unit: "pt", // Possible values are "pt" (points), "mm", "cm", "m", "in" or "px".
                        format: "a4", // a5, letter
                        orientation: 'landscape' // landscape o portrait
                    }
                })
                .from($elementoParaConvertir)
                .save()
                .catch(err => console.log(err));

            $('.loading').hide();
        });
    }

    $('.certificado_btn_').click((e) => {
        e.preventDefault();
        const $elementoParaConvertir = document.getElementById('content_pdf'); // <-- Aquí puedes elegir cualquier elemento del DOM
        // html2pdf().from($elementoParaConvertir).toCanvas().save('certificado.pdf');

        html2pdf()
            .set({
                // margin: 1,
                filename: 'certificado.pdf',
                image: {
                    type: 'jpeg',
                    quality: 1
                },
                // https://html2canvas.hertzen.com/configuration
                html2canvas: {
                    scale: 4, // A mayor escala, mejores gráficos, pero más peso
                    letterRendering: true,
                    // windowWidth: 578,
                    // windowHeight: 810,
                    // width: 578,
                    // height: 810,
                    // x: 0,
                    // y: 0,
                },
                // https://rawgit.com/MrRio/jsPDF/master/docs/jsPDF.html
                jsPDF: {
                    unit: "pt", // Possible values are "pt" (points), "mm", "cm", "m", "in" or "px".
                    format: "a4", // a5, letter
                    orientation: 'landscape' // landscape o portrait
                }
            })
            .from($elementoParaConvertir)
            .save()
            .catch(err => console.log(err));

    });


    function preguntas() {
        var html = "";
        // consultamos las preguntas
        var preguntas = local.getPreguntas();
        preguntas.map((v) => {
            html += '<div class="radio mb-4">';
            html += '<h5 class="mb-3"> ' + v.pregunta + ' </h5>';
            v.respuestas.map((r) => {
                html += '<div class="d-block">';
                html += '<input type="radio" class="respuestas" name="respuestas[' + v.id + ']" value="' + r.id + '" id="opcion-' + v.id + '-' + r.id + '" data-pregunta="' + v.id + '">';
                if (r.type == "text") {
                    html += '<label id="label-' + v.id + '-' + r.id + '" for="opcion-' + v.id + '-' + r.id + '">' + r.text + '</label>';
                } else if (r.type == "image") {
                    html += '<label id="label-' + v.id + '-' + r.id + '" for="opcion-' + v.id + '-' + r.id + '">';
                    html += '<img src="' + r.url + '" alt="..." style="height: 90px;"> ';
                    html += '</label>';
                }

                html += '</div>';
            })
            html += '</div>';
        })
        $('form.formulario').html(html);
    }

    // cerra session
    $('.bt_cerrarSession').click((e) => {
        e.preventDefault();
        $('.loading').show();
        local.cerrarSession();
        setTimeout(() => {
            window.location.replace("login.html");
        }, 500)
    });

    $(' .galerias_items ').lightGallery({
        thumbnail: true,
        animateThumb: false,
        showThumbByDefault: false
    });

    $(".content_video video").on("click", function(e) {
        $(".content_titutlo").toggleClass("d-none");
    });


    $(".custom-video-area").each(function() {
        // Video
        var $video_container = $(this);
        var $video = $(this).find("#video-element");

        // Video Controls
        var $video_controls = $(this).find(".video-controls");
        var $button_controls = $(this).find(".bottom-wrapper");
        var $progress_bar = $(this).find(".progress-bar");
        var $progress = $(this).find(".time-bar");
        var $buffer_bar = $(this).find(".buffer-bar");
        var $play_button = $(this).find(".play-button");
        var $mute_button = $(this).find(".sound-button");

        var $volume_wrapper = $(this).find(".volume");
        var $volume_bar = $(this).find(".volume-bar");

        var $full_screen_btn = $(this).find(".btnFS");
        var $current = $(this).find(".current");
        var $duration = $(this).find(".duration");
        var $fast_fwd = $(this).find("#fastFwd");

        // Toggles play/pause for the video
        function playVideo() {
            if ($video[0].paused) {
                $video[0].play();
                $video_controls.addClass("playing");

                if ($video_container.parents(".video-header").length) {
                    $video_container.parents(".video-header").addClass("playing");
                }
            } else {
                $video[0].pause();
                $video_controls.removeClass("playing");
                $video_container.parents(".video-header").removeClass("playing");
            }
        }

        function updateVolume(x, vol) {
            if (vol) {
                $percentage = vol * 100;
            } else {
                $position = x - $volume_wrapper.offset().left;
                $percentage = 100 * $position / $volume_wrapper.width();
            }

            if ($percentage > 100) {
                $percentage = 100;
            }
            if ($percentage < 0) {
                $percentage = 0;
            }

            //update volume bar and video volume
            $volume_bar.css("width", $percentage + "%");
            $video[0].volume = $percentage / 100;

            if ($video[0].volume == 0) {
                $mute_button.removeClass("sound-med").addClass("sound-muted");
            } else if ($video[0].volume > 0.5) {
                $mute_button.removeClass("sound-muted").addClass("sound-med");
            } else {
                $mute_button.removeClass("sound-muted").removeClass("sound-med");
            }
        }

        function changeSpeed() {
            if ($video[0].playbackRate === 1) {
                $video[0].playbackRate = 2;
                $fast_fwd.text("2x Speed");
            } else if ($video[0].playbackRate === 2) {
                $video[0].playbackRate = 1;
                $fast_fwd.text("1x Speed");
            }
        }

        function launchFullscreen() {
            if ($video[0].requestFullscreen) {
                $video[0].requestFullscreen();
            } else if ($video[0].mozRequestFullScreen) {
                $video[0].mozRequestFullScreen();
            } else if ($video[0].webkitRequestFullscreen) {
                $video[0].webkitRequestFullscreen();
            } else if ($video[0].msRequestFullscreen) {
                $video[0].msRequestFullscreen();
            }
        }

        function time_format(seconds) {
            var m = Math.floor(seconds / 60) < 10 ?
                "0" + Math.floor(seconds / 60) :
                Math.floor(seconds / 60);
            var s = Math.floor(seconds - m * 60) < 10 ?
                "0" + Math.floor(seconds - m * 60) :
                Math.floor(seconds - m * 60);
            return m + ":" + s;
        }

        function startBuffer() {
            $current_buffer = $video[0].buffered.end(0);
            $max_duration = $video[0].duration;
            $perc = 100 * $current_buffer / $max_duration;
            $buffer_bar.css("width", $perc + "%");

            if ($current_buffer < $max_duration) {
                setTimeout(startBuffer, 500);
            }
        }

        function updatebar(x) {
            $position = x - $progress.offset().left;
            $percentage = 100 * $position / $progress_bar.width();
            if ($percentage > 100) {
                $percentage = 100;
            }
            if ($percentage < 0) {
                $percentage = 0;
            }
            $progress.css("width", $percentage + "%");
            $video[0].currentTime = $video[0].duration * $percentage / 100;
        }

        $video.on("loadedmetadata", function() {
            $current.text(time_format(0));
            $duration.text(time_format($video[0].duration));
            updateVolume(0, 0.7);
            setTimeout(startBuffer, 150);
        });

        // Play/pause on video click
        $video.click(function() {
            playVideo();
            $(".video_content").toggleClass("d-none");
        });

        // Video duration timer
        $video.on("timeupdate", function() {
            $current.text(time_format($video[0].currentTime));
            $duration.text(time_format($video[0].duration));
            var currentPos = $video[0].currentTime;
            var maxduration = $video[0].duration;
            var perc = 100 * $video[0].currentTime / $video[0].duration;
            $progress.css("width", perc + "%");
        });

        /* VIDEO CONTROLS
              ------------------------------------------------------- */

        // Hide button controls when video is playing
        $video_container.on("mouseleave", function() {
            if ($video[0].paused === false) {
                $video_container.addClass("playing");
            }
        });

        // Show button controls on hover
        $video_container.on("mouseover", function() {});

        // Play/pause on button click
        $play_button.click(function() {
            playVideo();
            $(".video_content").toggleClass("d-none");
        });

        // Fast Forward Button
        $fast_fwd.click(function() {
            changeSpeed();
        });

        // Volume Drag
        var volumeDrag = false;
        $volume_wrapper.on("mousedown", function(e) {
            volumeDrag = true;
            $video[0].muted = false;
            $mute_button.removeClass("muted");
            updateVolume(e.pageX);
        });

        $(document).on("mouseup", function(e) {
            if (volumeDrag) {
                volumeDrag = false;
                updateVolume(e.pageX);
            }
        });

        $(document).on("mousemove", function(e) {
            if (volumeDrag) {
                updateVolume(e.pageX);
            }
        });

        // Mute video on button click
        $mute_button.click(function() {
            $video[0].muted = !$video[0].muted;
            $(this).toggleClass("sound-muted");
            if ($video[0].muted) {
                $volume_bar.css("width", 0);
            } else {
                $volume_bar.css("width", $video[0].volume * 100 + "%");
            }
        });

        // Full Screen Button
        $full_screen_btn.click(function() {
            launchFullscreen();
        });

        // VIDEO PROGRESS BAR
        //when video timebar clicked
        var timeDrag = false; /* check for drag event */
        $progress_bar.on("mousedown", function(e) {
            timeDrag = true;
            updatebar(e.pageX);
        });
        $(document).on("mouseup", function(e) {
            if (timeDrag) {
                timeDrag = false;
                updatebar(e.pageX);
            }
        });
        $(document).on("mousemove", function(e) {
            if (timeDrag) {
                updatebar(e.pageX);
            }
        });

    });



    // Possible improvements:
    // - Change timeline and volume slider into input sliders, reskinned
    // - Change into Vue or React component
    // - Be able to grab a custom title instead of "Music Song"
    // - Hover over sliders to see preview of timestamp/volume change

    const audioPlayer = document.querySelector(".audio-player");
    if (audioPlayer) {
        const audio = new Audio(
            "https://ia800905.us.archive.org/19/items/FREE_background_music_dhalius/backsound.mp3"
        );
        //credit for song: Adrian kreativaweb@gmail.com

        console.dir(audio);

        audio.addEventListener(
            "loadeddata",
            () => {
                audioPlayer.querySelector(".time .length").textContent = getTimeCodeFromNum(
                    audio.duration
                );
                audio.volume = 0.75;
            },
            false
        );

        //click on timeline to skip around
        const timeline = audioPlayer.querySelector(".timeline");
        timeline.addEventListener(
            "click",
            (e) => {
                const timelineWidth = window.getComputedStyle(timeline).width;
                const timeToSeek = (e.offsetX / parseInt(timelineWidth)) * audio.duration;
                audio.currentTime = timeToSeek;
            },
            false
        );

        //click volume slider to change volume
        const volumeSlider = audioPlayer.querySelector(".controls .volume-slider");
        volumeSlider.addEventListener(
            "click",
            (e) => {
                const sliderWidth = window.getComputedStyle(volumeSlider).width;
                const newVolume = e.offsetX / parseInt(sliderWidth);
                audio.volume = newVolume;
                audioPlayer.querySelector(".controls .volume-percentage").style.width =
                    newVolume * 100 + "%";
            },
            false
        );

        //check audio percentage and update time accordingly
        setInterval(() => {
            const progressBar = audioPlayer.querySelector(".progress");
            progressBar.style.width = (audio.currentTime / audio.duration) * 100 + "%";
            audioPlayer.querySelector(".time .current").textContent = getTimeCodeFromNum(
                audio.currentTime
            );
        }, 500);

        //toggle between playing and pausing on button click
        const playBtn = audioPlayer.querySelector(".controls .toggle-play");
        playBtn.addEventListener(
            "click",
            () => {
                if (audio.paused) {
                    playBtn.classList.remove("play");
                    playBtn.classList.add("pause");
                    audio.play();
                } else {
                    playBtn.classList.remove("pause");
                    playBtn.classList.add("play");
                    audio.pause();
                }
            },
            false
        );

        audioPlayer.querySelector(".volume-button").addEventListener("click", () => {
            const volumeEl = audioPlayer.querySelector(".volume-container .volume");
            audio.muted = !audio.muted;
            if (audio.muted) {
                volumeEl.classList.remove("icono-volumeMedium");
                volumeEl.classList.add("icono-volumeMute");
            } else {
                volumeEl.classList.add("icono-volumeMedium");
                volumeEl.classList.remove("icono-volumeMute");
            }
        });
    }

    //turn 128 seconds into 2:08
    function getTimeCodeFromNum(num) {
        let seconds = parseInt(num);
        let minutes = parseInt(seconds / 60);
        seconds -= minutes * 60;
        const hours = parseInt(minutes / 60);
        minutes -= hours * 60;

        if (hours === 0) return `${minutes}:${String(seconds % 60).padStart(2, 0)}`;
        return `${String(hours).padStart(2, 0)}:${minutes}:${String(
            seconds % 60
        ).padStart(2, 0)}`;
    } 
 
    $('#Models-1').modal('show');
    $('.btn_models').on('click', function() {
        var indicador = '.btn_models';
        var _next = $(this).attr('data-next');
        var _back = $(this).attr('data-back');
        if ($(this).hasClass('next')) {
            indicador = _next;
        } else if ($(this).hasClass('back')) {
            indicador = _back;
        }
        $('.modal_pasos').modal('hide'), 1000;
        $('#Models-' + indicador).modal('show'), 1000;
        $('#Models-' + indicador).modal('hide'), 1000;
    });

    

});